/*
 * Decompiled with CFR 0.152.
 */
package es.ejie.frmk.listeners.validadorremoto;

import es.ejie.frmk.control.excepciones.Q70GestorDeExcepciones;
import es.ejie.frmk.infraestructura.logs.navegacion.Q70LogNavegacion;
import es.ejie.frmk.infraestructura.tablas.Q70GestorTablasCodigos;
import es.ejie.frmk.infraestructura.tablas.Q70GestorTablasException;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.listeners.base.Q70HTTPListener;
import es.ejie.frmk.listeners.base.Q70LogDataUtils;
import es.ejie.frmk.listeners.validadorremoto.Q70ValidadorRemotoException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.DynaBean;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;

public class Q70ValidadorRemotoListener
extends HttpServlet
implements Q70HTTPListener {
    private static final String COMPONENTE = "VALIDADOR_REMOTO";
    private static final String CANAL = "BROWSER-PC AUXILIAR";
    private static Q70Traza tr = null;
    private static Q70LogNavegacion logNav = null;

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            if (null == tr) {
                tr = Q70Traza.getSingleton();
            }
            if (null == logNav) {
                logNav = Q70LogNavegacion.getSingleton();
            }
            Q70LogDataUtils.processPrepareLogData(httpServletRequest, CANAL, COMPONENTE);
            this.writeNavLogBegin();
            this.listen(httpServletRequest, httpServletResponse);
            this.writeNavLogEnd();
        }
        catch (ServletException servletException) {
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "ServletException.");
            }
            this.catchGenericThrowables(servletException, httpServletRequest, httpServletResponse);
        }
        catch (IOException iOException) {
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "IOException.");
            }
            this.catchGenericThrowables(iOException, httpServletRequest, httpServletResponse);
        }
        catch (Throwable throwable) {
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Throwable recogida por el Q70ListasEnlazadasListener.");
            }
            this.catchGenericThrowables(throwable, httpServletRequest, httpServletResponse);
        }
        Q70LogDataUtils.clearLogData(COMPONENTE);
    }

    public void listen(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, Q70ValidadorRemotoException {
        this.process(httpServletRequest, httpServletResponse);
    }

    public void catchGenericThrowables(Throwable throwable, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Q70GestorDeExcepciones.getSingleton().recogerThrowable(throwable, httpServletRequest, httpServletResponse);
    }

    public void writeNavLogBegin() {
        logNav.log("OK", "ENTRADA");
    }

    public void writeNavLogEnd() {
        logNav.log("OK", "SALIDA");
    }

    public void dispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    private void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Q70ValidadorRemotoException, IOException {
        CharSequence charSequence;
        if (tr.isTraceActive()) {
            charSequence = new StringBuffer("Q70ValidadorRemotoListener: Procesando peticion con valores: \n");
            ((StringBuffer)charSequence).append("-retFunc=").append(httpServletRequest.getParameter("retFunc")).append("\n").append("-targetTag=").append(httpServletRequest.getParameter("targetTag")).append("\n").append("-targetTagValue=").append(httpServletRequest.getParameter("targetTagValue")).append("\n").append("-sourceTag=").append(httpServletRequest.getParameter("sourceTag")).append("\n").append("-sourceTagValue=").append(httpServletRequest.getParameter("sourceTagValue")).append("\n").append("-table=").append(httpServletRequest.getParameter("table")).append("\n").append("-subjectColumn=").append(httpServletRequest.getParameter("subjectColumn")).append("\n").append("-predicateColumn=").append(httpServletRequest.getParameter("predicateColumn")).append("\n").append("-predicateColumnNumeric=").append(httpServletRequest.getParameter("predicateColumnNumeric")).append("\n").append("-extraPredicate=").append(httpServletRequest.getParameter("extraPredicate")).append("\n").append("-locale=").append(httpServletRequest.getLocale().toString());
            tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, ((StringBuffer)charSequence).toString());
        }
        charSequence = this.getDescription(httpServletRequest.getParameter("targetTagValue"), httpServletRequest.getParameter("sourceTagValue"), httpServletRequest.getParameter("table"), httpServletRequest.getParameter("subjectColumn"), httpServletRequest.getParameter("predicateColumn"), httpServletRequest.getParameter("predicateColumnNumeric"), httpServletRequest.getParameter("extraPredicate"), httpServletRequest.getLocale());
        String string = this.composeHtmlResponse(httpServletRequest.getParameter("formName"), httpServletRequest.getParameter("targetTag"), httpServletRequest.getParameter("targetTagValue"), httpServletRequest.getParameter("sourceTag"), httpServletRequest.getParameter("sourceTagValue"), httpServletRequest.getParameter("retFunc"), (String)charSequence);
        if (httpServletRequest.getParameter("technology") != null && httpServletRequest.getParameter("technology").equalsIgnoreCase("iframe")) {
            this.sendResponse(string, httpServletResponse);
        } else {
            this.composeXmlResponse(httpServletRequest.getParameter("formName"), httpServletRequest.getParameter("targetTag"), httpServletRequest.getParameter("targetTagValue"), httpServletRequest.getParameter("sourceTag"), httpServletRequest.getParameter("sourceTagValue"), httpServletRequest.getParameter("retFunc"), (String)charSequence, httpServletResponse);
        }
    }

    private String getDescription(String string, String string2, String string3, String string4, String string5, String string6, String string7, Locale locale) throws Q70ValidadorRemotoException {
        String string8 = "";
        try {
            DynaBean dynaBean;
            Serializable serializable;
            Vector<String> vector = new Vector<String>(2);
            if (string5 != null && string5.length() > 0) {
                vector.add(string5);
            }
            if (string4 != null && string4.length() > 0) {
                vector.add(string4);
            }
            String string9 = null == string2 || 0 == string2.trim().length() ? string : string2;
            StringBuffer stringBuffer = new StringBuffer(64);
            if (null != string9 && 0 < string9.trim().length()) {
                stringBuffer.append(string5);
                stringBuffer.append("=");
                if (string6.equals("true")) {
                    stringBuffer.append(string9);
                } else {
                    stringBuffer.append("'").append(string9).append("'");
                }
            }
            if (null != string7 && 0 < string7.trim().length()) {
                stringBuffer.append(stringBuffer.length() > 0 ? " AND " : "").append("(").append(string7).append(")");
            }
            if (tr.isTraceActive()) {
                serializable = new StringBuffer("Q70ValidadorRemotoListener: Llamando al Gestor de Tablas y Codigos con valores: \n");
                ((StringBuffer)serializable).append("-table=").append(string3).append("\n").append("-where=").append(stringBuffer.toString()).append("\n").append("-lenguage=").append(locale.getLanguage()).append("\n").append("-cols=").append(vector.toString());
                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, ((StringBuffer)serializable).toString());
            }
            if (!(serializable = Q70GestorTablasCodigos.getSingleton().selectRecordsFromTable(string3, stringBuffer.toString(), locale.getLanguage(), vector)).isEmpty() && (dynaBean = (DynaBean)serializable.iterator().next()).get(string4) != null) {
                string8 = dynaBean.get(string4).toString();
            }
        }
        catch (Q70GestorTablasException q70GestorTablasException) {
            throw new Q70ValidadorRemotoException(this.getClass().toString(), "getDescription", "Excepcion generada por el Gestor de Tablas y Codigos", q70GestorTablasException);
        }
        catch (Exception exception) {
            throw new Q70ValidadorRemotoException(this.getClass().toString(), "getDescription", "Excepcion sin especificar recogida", exception);
        }
        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q70ValidadorRemotoListener: El resultado de la consulta contra el Gestor de Tablas y Codigos es: " + string8);
        }
        return string8;
    }

    private String composeHtmlResponse(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Q70ValidadorRemotoException {
        StringBuffer stringBuffer = null;
        try {
            String string8 = this.getReturnTag(string4, string2);
            stringBuffer = new StringBuffer(256);
            stringBuffer.append("<script language='JavaScript' type='text/javascript'>").append("parent.");
            if (null != string6 && 0 < string6.length()) {
                if (string6.indexOf("()") > 0) {
                    string6.substring(string6.length() - 2);
                }
                stringBuffer.append(string6);
                stringBuffer.append("('");
                stringBuffer.append(string8.equals(string4) ? string7 : string5);
                stringBuffer.append("','");
                stringBuffer.append(string8.equals(string2) ? string7 : string3);
                stringBuffer.append("');");
            } else if (null == string7 || 0 == string7.trim().length()) {
                if (string2 != null && string2.trim().length() > 0) {
                    stringBuffer.append("document.").append(string).append(".").append(string2).append(".value='';");
                }
                if (string4 != null && string4.trim().length() > 0) {
                    stringBuffer.append("parent.document.").append(string).append(".").append(string4).append(".value='';");
                }
            } else {
                stringBuffer.append("document.").append(string).append(".").append(string8).append(".value='").append(string7).append("';");
            }
            stringBuffer.append("</script>");
        }
        catch (Exception exception) {
            throw new Q70ValidadorRemotoException(this.getClass().toString(), "getDescription", exception.getMessage(), exception);
        }
        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q70ValidadorRemotoListener: El codigo html a devolver es: " + (null != stringBuffer ? stringBuffer.toString() : ""));
        }
        return null != stringBuffer ? stringBuffer.toString() : "";
    }

    private String composeXmlResponse(String string, String string2, String string3, String string4, String string5, String string6, String string7, HttpServletResponse httpServletResponse) throws Q70ValidadorRemotoException {
        StringBuffer stringBuffer = null;
        try {
            String string8 = this.getReturnTag(string4, string2);
            XMLOutputStreamFactory xMLOutputStreamFactory = XMLOutputStreamFactory.newInstance();
            XMLOutputStream xMLOutputStream = xMLOutputStreamFactory.newOutputStream((OutputStream)httpServletResponse.getOutputStream());
            httpServletResponse.setContentType("text/xml");
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"listenerResponse"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"listener"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"validadorRemoto"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"listener"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"elementos"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
            string7 = string7 == null ? "" : string7.trim();
            if (null != string6 && 0 < string6.length()) {
                if (string6.indexOf("()") > 0) {
                    string6.substring(string6.length() - 2);
                }
                xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"funcionRetorno"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)string6));
                xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"funcionRetorno"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"parametro1"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)(string8.equals(string4) ? string7 : string5)));
                xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"parametro1"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"parametro2"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)string7));
                xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"parametro2"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
            } else {
                xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"formulario"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)string));
                xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"formulario"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"tag"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)string8));
                xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"tag"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"datos"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)string7));
                xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"datos"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
            }
            xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"elementos"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"listenerResponse"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
            xMLOutputStream.flush();
            xMLOutputStream.close();
        }
        catch (Exception exception) {
            throw new Q70ValidadorRemotoException(this.getClass().toString(), "getDescription", exception.getMessage(), exception);
        }
        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q70ValidadorRemotoListener: El codigo html a devolver es: " + (null != stringBuffer ? stringBuffer.toString() : ""));
        }
        return string7;
    }

    private void sendResponse(String string, HttpServletResponse httpServletResponse) throws IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.println(string);
        servletOutputStream.flush();
    }

    private String getReturnTag(String string, String string2) {
        if (null == string || 0 == string.trim().length()) {
            return string2;
        }
        if (null != string2 && 0 < string2.length()) {
            return string2;
        }
        return string;
    }
}

